<!-- This template is used for proposing changes to the left sidebar contextual navigation. This could include additions, removals, or general changes to overall hierarchy.-->

### Proposal 

<!-- Use this section to explain the proposed changes, including details around usage and business drivers. -->


#### Other locations that were considered

 <!-- Include other design patterns or places you considered for this feature besides navigation. -->

### Checklist

- [ ] Review the handbook page for [navigation changes](https://about.gitlab.com/handbook/product/ux/navigation/#when-to-consider-making-a-change-to-the-navigation)
- [ ] Add relevant information to the issue description detailing your proposal, including usage and business drivers.
- [ ] List at least two other places you considered to introduce your feature
- [ ] Add relevant designs to the Design Management area of the issue
- [ ] Ensure your UI suggestion align with the [Documentation Style Guide](https://docs.gitlab.com/ee/development/documentation/styleguide/)
- [ ] Engage ~"Technical Writing". They can help craft a term that best describes the feature(s) you’re proposing. 
- [ ] Follow the [product development workflow](https://about.gitlab.com/handbook/product-development-flow/#validation-phase-2-problem-validation) validation process to ensure you are solving a well understood problem and that the proposed change is understandable and non-disruptive to users. Navigation-specific research is mandatory for additions or when restructuring.
- [ ] Engage the [Foundations Product Manager](https://about.gitlab.com/handbook/product/categories/#foundations-group) for approval. The Foundations DRI (@cdybenko) will work with UX partners in product design, research, and technical writing, as applicable.
- [ ] Consider whether you need to [communicate the change somehow](https://design.gitlab.com/patterns/navigation#messaging-changes-to-users), or if you will have an interim period in the UI where your item will live in more than one place.
- [ ] Ensure engineers are familiar with the [implementation steps for navigation](https://docs.gitlab.com/ee/development/navigation_sidebar.html#navigation-sidebar).

/label ~UX ~"UI text" ~"documentation" ~"Category:Navigation & Settings"  ~navigation ~type::ignore
/label ~"Nav request::Start"  
